<?php
require_once __DIR__ . '/includes/auth.php';
require_login();

require_once __DIR__ . '/includes/functions.php';

$title  = 'Portals';
$active = 'portals';

/* =========================================================
   SAVE HANDLER – FULL OVERRIDE MODE
   ========================================================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['portals'])) {

    $final = [];
    $id = 0;

    foreach ($_POST['portals'] as $p) {

        $name = trim($p['name'] ?? '');
        $url  = trim($p['url'] ?? '');

        // DROP empty or disabled portals
        if ($name === '' || $url === '' || empty($p['enabled'])) {
            continue;
        }

        $final[] = [
            'id'      => $id++,
            'name'    => $name,
            'url'     => $url,
            'enabled' => true
        ];
    }

    file_put_contents(
        $_SERVER['DOCUMENT_ROOT'] . '/wave/public/portals.json',
        json_encode(['portals' => $final], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)
    );

    header('Location: portals.php?saved=1');
    exit;
}

/* =========================================================
   LOAD CURRENT DATA
   ========================================================= */
$data    = read_portals();
$portals = $data['portals'] ?? [];

include __DIR__ . '/includes/header.php';
?>

<style>
/* =========================================================
   MOBILE FRIENDLY – SMALL CARDS ONLY (VISUAL)
   ========================================================= */
@media (max-width: 768px) {

  table thead {
    display: none;
  }

  table tbody tr {
    display: block;
    background: #0f0f1a;
    border: 1px solid rgba(255,255,255,.12);
    border-radius: 10px;       /* smaller radius */
    padding: 8px;              /* smaller padding */
    margin-bottom: 10px;       /* tighter spacing */
  }

  table tbody td {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border: none;
    padding: 4px 0;            /* tighter rows */
  }

  table tbody td::before {
    content: attr(data-label);
    font-size: 11px;           /* smaller label */
    color: #9ca3af;
    margin-right: 8px;
  }

  .row-index {
    display: none;
  }

  input.form-control-sm {
    font-size: 13px;           /* smaller input text */
    padding: 4px 6px;          /* smaller input */
    height: auto;
  }
}
</style>

<div class="container-fluid">

<?php if (isset($_GET['saved'])): ?>
  <div class="alert alert-success">Portals saved & file rebuilt</div>
<?php endif; ?>

<div class="card bg-dark border-secondary">
  <div class="card-header d-flex justify-content-between align-items-center">
    <div>
      <strong>DNS Portals</strong>
      <div class="text-muted small">
        Empty or disabled rows are removed on save
      </div>
    </div>

    <button type="button" class="btn btn-sm btn-primary" onclick="addRow()">
      ➕ Add new row
    </button>
  </div>

  <form method="post" id="portalsForm">
    <div class="card-body p-0">
      <table class="table table-dark table-striped mb-0" id="portalsTable">
        <thead>
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>DNS URL</th>
            <th class="text-center">Enabled</th>
          </tr>
        </thead>
        <tbody>

        <?php if (empty($portals)): ?>
          <tr class="empty">
            <td colspan="4" class="text-center text-muted p-4">
              No portals defined — click “Add new row”
            </td>
          </tr>
        <?php endif; ?>

        <?php foreach ($portals as $i => $p): ?>
          <tr>
            <td class="row-index" data-label="#">
              <?= $i + 1 ?>
            </td>

            <td data-label="Name">
              <input class="form-control form-control-sm"
                     name="portals[<?= $i ?>][name]"
                     value="<?= htmlspecialchars($p['name']) ?>">
            </td>

            <td data-label="DNS URL">
              <input class="form-control form-control-sm"
                     name="portals[<?= $i ?>][url]"
                     value="<?= htmlspecialchars($p['url']) ?>">
            </td>

            <td data-label="Enabled" class="text-center">
              <input type="checkbox"
                     name="portals[<?= $i ?>][enabled]"
                     checked>
            </td>
          </tr>
        <?php endforeach; ?>

        </tbody>
      </table>
    </div>

    <div class="card-footer text-right">
      <button class="btn btn-success">
        Save & Rebuild
      </button>
    </div>
  </form>
</div>

</div>

<script>
let rowIndex = <?= count($portals) ?>;

function addRow() {
    const tbody = document.querySelector('#portalsTable tbody');

    const emptyRow = tbody.querySelector('.empty');
    if (emptyRow) emptyRow.remove();

    const tr = document.createElement('tr');

    tr.innerHTML = `
      <td class="row-index" data-label="#">${rowIndex + 1}</td>
      <td data-label="Name">
        <input class="form-control form-control-sm"
               name="portals[${rowIndex}][name]"
               placeholder="Portal name">
      </td>
      <td data-label="DNS URL">
        <input class="form-control form-control-sm"
               name="portals[${rowIndex}][url]"
               placeholder="http://example.com">
      </td>
      <td data-label="Enabled" class="text-center">
        <input type="checkbox"
               name="portals[${rowIndex}][enabled]"
               checked>
      </td>
    `;

    tbody.appendChild(tr);
    rowIndex++;
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
