<?php
/* =========================================================
   PORTALS FUNCTIONS – AUTO-DISABLE EMPTY URL
   ========================================================= */

define(
    'PORTALS_FILE',
    $_SERVER['DOCUMENT_ROOT'] . '/wave/public/portals.json'
);

/* -------------------------
   READ PORTALS (RAW)
-------------------------- */
function read_portals(): array {
    if (!file_exists(PORTALS_FILE)) {
        return ['portals' => []];
    }

    $json = file_get_contents(PORTALS_FILE);
    $data = json_decode($json, true);

    if (!is_array($data) || !isset($data['portals'])) {
        return ['portals' => []];
    }

    return $data;
}

/* -------------------------
   SAVE PORTALS
   🔒 AUTO-DISABLE IF URL EMPTY
-------------------------- */
function save_portals(array $data): void {

    if (!isset($data['portals']) || !is_array($data['portals'])) {
        return;
    }

    foreach ($data['portals'] as &$p) {
        $p['name'] = trim($p['name'] ?? '');
        $p['url']  = trim($p['url'] ?? '');

        // 🚨 AUTO-DISABLE IF URL IS EMPTY
        if ($p['url'] === '') {
            $p['enabled'] = false;
        } else {
            $p['enabled'] = normalize_enabled($p['enabled'] ?? false);
        }
    }

    file_put_contents(
        PORTALS_FILE,
        json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)
    );
}

/* ---------------------------------------------------------
   APP / APK SAFE PORTALS
   ✅ enabled + non-empty only
---------------------------------------------------------- */
function get_enabled_portals(): array {

    $data = read_portals();
    $out = [];

    foreach ($data['portals'] as $p) {

        if (
            normalize_enabled($p['enabled'] ?? false) &&
            trim($p['name'] ?? '') !== '' &&
            trim($p['url'] ?? '') !== ''
        ) {
            $out[] = $p;
        }
    }

    return $out;
}

/* -------------------------
   NORMALIZE ENABLE FLAG
-------------------------- */
function normalize_enabled($value): bool {
    return (
        $value === true ||
        $value === 1 ||
        $value === '1' ||
        $value === 'true'
    );
}

/* -------------------------
   DASHBOARD COUNTER
-------------------------- */
function count_enabled_portals(): int {
    return count(get_enabled_portals());
}
