
document.addEventListener('DOMContentLoaded', function(){
  var btn = document.getElementById('menu-toggle');
  if(btn){
    btn.addEventListener('click', function(e){
      e.preventDefault();
      var wrapper = document.getElementById('wrapper');
      if(wrapper) wrapper.classList.toggle('toggled');
    });
  }
  var enableAll = document.querySelector('[data-action="enable-all"]');
  var disableAll = document.querySelector('[data-action="disable-all"]');
  function toggles(){ return Array.from(document.querySelectorAll('input[name^="enabled_"]')); }
  if(enableAll) enableAll.addEventListener('click', ()=> toggles().forEach(x=>x.checked=true));
  if(disableAll) disableAll.addEventListener('click', ()=> toggles().forEach(x=>x.checked=false));

  // message bar
  var msg = document.body.getAttribute('data-message');
  var type = document.body.getAttribute('data-message-type') || 'info';
  if(msg){
    var el = document.getElementById('pageMessages');
    if(el){
      el.innerHTML = '<div class="alert alert-'+(type==='error'?'danger':type)+' py-1 px-2 mb-0" style="border-radius:8px;">'
        + msg + '</div>';
      setTimeout(()=>{ el.innerHTML=''; }, 2800);
    }
  }
});
